#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

static Obj3d Canard;
static Obj3d *pPlaque;
static float Matrix[16], Matrix2[16], Gouraud[16], Gouraud2[16];

void LInit_Canard()
{
	FILE *file;
	DWORD Cpt1;
	unsigned short A,B,C;

	file = fopen("canard.n3d", "rb");
	fread(&Canard.NbVertex, 4, 1, file);
	Canard.pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*Canard.NbVertex);
	Canard.pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*Canard.NbVertex);
	for(Cpt1=0;Cpt1<Canard.NbVertex;Cpt1++)
	{
		fread(&Canard.pVertexIn[Cpt1].x, 4, 1, file);
		fread(&Canard.pVertexIn[Cpt1].y, 4, 1, file);
		fread(&Canard.pVertexIn[Cpt1].z, 4, 1, file);
		fread(&Canard.pVertexIn[Cpt1].tmuvtx[0].sow, 4, 1, file);
		fread(&Canard.pVertexIn[Cpt1].tmuvtx[0].tow, 4, 1, file);
	}
	fread(&Canard.NbFaces, 4, 1, file);
	Canard.pFace = (Face*)malloc(sizeof(Face)*Canard.NbFaces);
	for(Cpt1=0;Cpt1<Canard.NbFaces;Cpt1++)
	{
		fread(&A, 2, 1, file);
		fread(&B, 2, 1, file);
		fread(&C, 2, 1, file);
		Canard.pFace[Cpt1].A = A;
		Canard.pFace[Cpt1].B = B;
		Canard.pFace[Cpt1].C = C;
	}
	fclose(file);

	ComputeGouraud(&Canard);
	BeIdentityMatrix(Gouraud);

	pPlaque = GenerateSphere(20, 20, 1500, 1500, 256, 256);
	ComputeGouraud(pPlaque);
}

void QInit_Canard()
{
	grSstControl(GR_CONTROL_ACTIVATE);
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_CONSTANT, FXFALSE);

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);
}

void Effect_Canard()
{
	float fTmp;

	fTmp = g_demostate.TickInEffect/300.f;

	BeIdentityMatrix(Matrix);
	BeIdentityMatrix(Gouraud);
	/*RotateXMatrix(Matrix2, Matrix, PI/2);
	RotateYMatrix(Matrix, Matrix2, fTmp);
	RotateYMatrix(Gouraud2, Gouraud, -fTmp);
	RotateXMatrix(Gouraud, Gouraud2, -PI/2);*/

	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect*4); // fTmp
	RotateZMatrix(Matrix, Matrix2, g_demostate.TickInEffect*2); // fTmp/2
	ScaleYMatrix(Matrix, 2.f);
	RotateZMatrix(Matrix2, Matrix, -(int)g_demostate.TickInEffect*2); // -fTmp/2
	RotateXMatrix(Matrix, Matrix2, -(int)g_demostate.TickInEffect*4); // -fTmp

	RotateXMatrix(Matrix2, Matrix, g_demostate.TickInEffect); // fTmp/4
	RotateYMatrix(Matrix, Matrix2, g_demostate.TickInEffect*4/3); // fTmp/3
	RotateZMatrix(Matrix2, Matrix, g_demostate.TickInEffect*2); // fTmp/2

	RotateZMatrix(Gouraud2, Gouraud, -(int)g_demostate.TickInEffect*2); // -fTmp/2
	RotateYMatrix(Gouraud, Gouraud2, -(int)g_demostate.TickInEffect*4/3); // -fTmp/3
	RotateXMatrix(Gouraud2, Gouraud, -(int)g_demostate.TickInEffect); // -fTmp/4

	TranslateMatrix(Matrix2, 0, 0, 4000);
	grConstantColorValue(0xffface00);
	DrawWithMatrix(&Canard, Matrix2, true, Gouraud2, 0);
}

void ByeBye_Canard()
{


}